// Szeroko ekranu
#define WIDTH 480
// Wysoko ekranu
#define HEIGHT 320
// Kolor pieczki gracza
#define BALL_COLOR 0x003f9f
// Kolor kropek znajdujcych si na pierwszym planie piki gracza
#define BALL_HICOLOR 0xffffff
// Kolor kropek znajdujcych si na dalszym planie
#define BALL_LOCOLOR 0x7f7fff
// Numer wierzcholkw na pice gracza
#define BALL_VERTEX_COUNT 10
// Promie kuli gracza
#define RADIUS 12
// Kolor ta
#define BG_COLOR 0x000000
// "Martwa strefa" joysticka
#define DEADZONE 3500
// Rozmiar pojedynczego, kwadratowego pola
#define TILESIZE 32

// Limit czasu
#define TIMELIMIT 10
#define PI 3.14159265358979323846
// Przyspieszenie gracza
#define THRUST 0.1f
// Przyspieszenie na liskiej powierzchni
#define SLIDE_POWER 0.04f
// Spowolnienie wywoane tarciem
#define SLOWDOWN 0.99f
// Spowolnienie spowodowane poruszaniem si po szorstkiej powierzchni
#define SLOWDOWN_ROUGH 0.95f

// Promie monety
#define COIN_RADIUS 8
// Kolor monety
#define COIN_COLOR 0xffff00

// Ilo iteracji fizyki na sekund
#define PHYSICS_IPS 100

// Kody pl
enum level_data_enum
{
  L_DROP = 0,
  L_GROUND = 1,
  L_START = 2,
  L_END = 3,
  L_COIN = 5,
  L_LEFT = 10,
  L_RIGHT = 11,
  L_UP = 12,
  L_DOWN = 13,
  L_SMOOTH = 25,
  L_ROUGH = 26
};

// Metody akceleracji pod linuksem
enum accel_enum
{
	VIDEO_DGA,
	VIDEO_X11
};

// Stany gry
enum game_state_enum
{
  S_INIT,
  S_ENTRY,
  S_READY,
  S_INGAME,
  S_FALLOFF,
  S_ENDLEVEL,
	S_TRANSITION_IN,
	S_TRANSITION_OUT
};

// Struktura monety
struct coin_s
{
  float X;
  float Y;
  int Color;
  int Radius;
  int Taken;
};

// Struktura wiechoka na pice gracza
struct vertex_s
{
	float X;
	float Y;
	float Z;
};

// Wastwa gwna gry
extern SDL_Surface *Screen;
// Warstwy potrzebne do efektu przejscia
extern SDL_Surface *ScreenTransition;
// Warstwa zawierajca pola gry
extern SDL_Surface *Tiles;
// Warstwa zawierajca czcionk
extern SDL_Surface *Font;
// Warstwa zawierajca tekstury
extern SDL_Surface *Texture;
// Iloc wyrenderowanych klatek od uruchomienia programu
extern int gFramesRendered;

extern int Lock;

// Wskanik do joystick'a
extern SDL_Joystick *Joystick;

// Cakowity numer monet
extern int CoinCount;
// Liczba zebranych monet
extern int CoinsTaken;
// Tablica monet
extern coin_s *Coin;

// Czas w poprzedniej iteracji
extern int LastTick;
// Czas od momentu inicjalizacji SDL
extern int Tick;
// Czas na pocztku level'u
extern int LevelStartTick;
// Numer aktualnego poziomu
extern int CurrentLevel;

// Wsprzdne gracza
extern float XPos;
extern float YPos;

// Wektor ruchu gracza
extern float XMov;
extern float YMov;

// Pozycja startowa gracza
extern float StartX;
extern float StartY;

// Wektor obrotu gracza
extern float XRoll;
extern float YRoll;

// Wektor obrotu pieczki gracza
extern float Roll;

// Stan klawiszy gracza
extern int KeyLeft;
extern int KeyRight;
extern int KeyUp;
extern int KeyDown;

// Punktacja gracza
extern int Score;

// Pozycja kamery
extern float CameraX;
extern float CameraY;

// Dane poziomu
extern unsigned char *Level;

// Nazwa poziomu
extern char *LevelName;
// Limit czasu danego poziomu
extern int LevelTime;

// Rozmiar poziomu mierzony w polach
extern int LevelWidth;
extern int LevelHeight;

// Tablica offset'w znakow
extern int FontOfs[];
// Tablica szerokoci znakw
extern int FontWidth[];

// Niezmodyfikowane wierzchoki
extern vertex_s *Vertex;
// Wierzchoki po transformacji
extern vertex_s *RVertex;

// Zaplanowany nastpny stan gry
extern int NextState;
// Obecny stan gry
extern int GameState;
// Czas od momentu startu nowego stanu
extern int StateStartTick;
// Czas od momentu startu transformacji
extern int TransitionStartTick;
// Czas od rozpoczecia gry
extern int Tick;

extern int Lock;
extern int Sound_Lock;
extern int Sound_Lock_1;
extern int FramesRendered;

extern char caption[5];
extern const char * ptr;

extern Mix_Music *music;
extern Mix_Chunk *s_coin;
extern Mix_Chunk *s_fall;
extern Mix_Chunk *s_winner;

extern void coincollision();
extern void reset();
extern void rendergame();
extern unsigned int blend_avg(unsigned int source, unsigned int target);
extern unsigned int blend_mul(unsigned int source, unsigned int target);
extern unsigned int blend_add(unsigned int source, unsigned int target);
extern void drawcircle(int x, int y, int r, int c);
extern void drawrect(int x, int y, int width, int height, int c);
extern void drawtile(int x, int y, int tile);
extern void drawcharacter(int x, int y, int character, int blend);
extern void drawstring(int x, int y, char *s);
extern void drawball(int x, int y, int r, int colorb, int color0,
                     int color1, float roty, float rotz);
extern void drawbackground(void);
extern void transition(float v);
extern void Play_Music(void);
extern void Close_Audio(void);

