#include <stdlib.h>
#include <string.h>
#include <iostream>
#include <math.h>
#include "SDL/SDL.h"
#include "SDL/SDL_mixer.h"
#include "include.h"

using namespace std;

void rotate_z(float angle)
{
  float ca = (float)cos(angle);
  float sa = (float)sin(angle);
  int i;
  for (i = 0; i < BALL_VERTEX_COUNT; i++)
  {
    float x = RVertex[i].X * ca - RVertex[i].Y * sa;
    float y = RVertex[i].X * sa + RVertex[i].Y * ca;
    RVertex[i].X = x;
    RVertex[i].Y = y;
  }
}

void rotate_y(float angle)
{
  float ca = (float)cos(angle);
  float sa = (float)sin(angle);
  int i;
  for (i = 0; i < BALL_VERTEX_COUNT; i++)
  {
    float z = RVertex[i].Z * ca - RVertex[i].X * sa;
    float x = RVertex[i].Z * sa + RVertex[i].X * ca;
    RVertex[i].Z = z;
    RVertex[i].X = x;
  }
}

void rotate_x(float angle)
{
  float ca = (float)cos(angle);
  float sa = (float)sin(angle);
  int i;
  for (i = 0; i < BALL_VERTEX_COUNT; i++)
  {
    float y = RVertex[i].Y * ca - RVertex[i].Z * sa;
    float z = RVertex[i].Y * sa + RVertex[i].Z * ca;
    RVertex[i].Y = y;
    RVertex[i].Z = z;
  }
}

void drawball(int x, int y, int r, int colorb, int color0,
              int color1, float roty, float rotz)
{
  int dotradius = (r / (RADIUS / 2));

  drawcircle(x, y, r, colorb);

  rotate_z(-rotz);
  rotate_y(roty);
  rotate_z(rotz);

  int i;

  for (i = 0; i < BALL_VERTEX_COUNT; i++)
  {
    if (RVertex[i].Z < 0)
      drawcircle((int)(RVertex[i].X * (r - dotradius) + x),
                 (int)(RVertex[i].Y * (r - dotradius) + y),
                 dotradius, color0);
  }

  for (i = 0; i < BALL_VERTEX_COUNT; i++)
  {
    if (RVertex[i].Z >= 0)
      drawcircle((int)(RVertex[i].X * (r - dotradius) + x),
                 (int)(RVertex[i].Y * (r - dotradius) + y),
                 dotradius, color1);
  }
}
